/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.ui.phpini.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPHPIniSectionDialog
extends TitleAreaDialog {
    private Text nameEdit;
    private String name;
    private List<String> forbiddenNames = null;

    public NewPHPIniSectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public void setForbiddenNames(List<String> names) {
        this.forbiddenNames = names;
    }

    protected void okPressed() {
        if (this.nameEdit != null) {
            this.name = this.nameEdit.getText();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite returned = (Composite)super.createDialogArea(parent);
        Composite par = new Composite(returned, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        par.setLayoutData((Object)data);
        this.getShell().setText(Messages.NewPHPIniSectionDialog_createSection);
        this.setTitle(Messages.NewPHPIniSectionDialog_createSection);
        this.setMessage(Messages.NewPHPIniSectionDialog_enterSectionNameMessage);
        par.setLayout((Layout)new GridLayout(4, false));
        this.createNameEdit(par);
        this.setTooltipText();
        return par;
    }

    private void createNameEdit(Composite par) {
        Label nameLabel = new Label(par, 0);
        nameLabel.setText(StringUtil.makeFormLabel((String)Messages.NewPHPIniSectionDialog_nameLabel));
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameEdit = new Text(par, 2048);
        this.nameEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.nameEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPIniSectionDialog.this.validate();
            }
        });
        if (this.name != null) {
            this.nameEdit.setText(this.name);
        }
    }

    protected void setTooltipText() {
        this.nameEdit.setToolTipText(Messages.NewPHPIniSectionDialog_enterSectionNameTooltip);
    }

    private void validate() {
        String nameText = this.nameEdit.getText();
        if (nameText.length() == 0) {
            this.disableOKButton();
            this.setErrorMessage(Messages.NewPHPIniSectionDialog_sectionNameMissingError);
            return;
        }
        String trimmedName = nameText.trim();
        if (this.forbiddenNames != null) {
            for (String forbiddenName : this.forbiddenNames) {
                if (!forbiddenName.equalsIgnoreCase(trimmedName)) continue;
                this.disableOKButton();
                this.setErrorMessage(Messages.NewPHPIniSectionDialog_sectionDuplicateError);
                return;
            }
        }
        this.setErrorMessage(null);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(true);
        }
    }

    private void disableOKButton() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(false);
        }
    }
}

